"use strict";
//
// Copyright 2023 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//
Object.defineProperty(exports, "__esModule", { value: true });
const ByteArray_1 = require("../internal/ByteArray");
const Native = require("../../../Native");
const CallLinkPublicParams_1 = require("./CallLinkPublicParams");
const Address_1 = require("../../Address");
class CallLinkSecretParams extends ByteArray_1.default {
    static deriveFromRootKey(callLinkRootKey) {
        return new CallLinkSecretParams(Native.CallLinkSecretParams_DeriveFromRootKey(callLinkRootKey));
    }
    constructor(contents) {
        super(contents, Native.CallLinkSecretParams_CheckValidContents);
    }
    getPublicParams() {
        return new CallLinkPublicParams_1.default(Native.CallLinkSecretParams_GetPublicParams(this.contents));
    }
    decryptUserId(userId) {
        return Address_1.Aci.parseFromServiceIdFixedWidthBinary(Native.CallLinkSecretParams_DecryptUserId(this.contents, userId.contents));
    }
}
exports.default = CallLinkSecretParams;
//# sourceMappingURL=CallLinkSecretParams.js.map